#include "typesiigs.r" 

/***/

#define MainWindow		$1000
#define ChFont			5
#define Header			11
#define Footer			12
#define Columns			13
#define ColumnText		15
#define HeaderText		16
#define FooterText		17
#define Borders			19
#define UseBorder		20
#define Hint			21
#define TextAsIs		22
#define HiBitOff		23
#define HiBitOn			24
#define ChangeTabs		25
#define BoxProc			26

/***/

#define AboutWindow		$2000
#define AboutOK			1
#define AboutText		2

/***/

#define PrintingWindow		$3000
#define PrintingText		3
#define PrintingCmdDotText	4

/***/

#define TabsWindow		$4000
#define TabsOK			1
#define TabsCancel		2
#define TabsData		103
#define TabChr			104
#define TabsDataText	5
#define TabChrText		6
#define MerlinTabs		20
#define MerlinTabsData	21

/*------------------------ Startup Record -----------------------*/

resource rToolStartup (1)	{
	mode640,							/* master SCB */
	{ 	
		3,$0300,	/* misc tools */
		4,$0301,	/* quickdraw */
		5,$0302,	/* desk manager */
		6,$0300,	/* eventMgr */
/*		7,$0200,	/* scheduler */
/*		8,$0301,	/* sound tools */
/*		9,$0201,	/* ADB tools */
/*		10,$0202,	/* SANE */
		11,$0200,	/* int math */
/*		12,$0201,	/* Text Tool Set */
		14,$0301,	/* Window Manager */
		15,$0301,	/* Menu Manager */
		16,$0301,	/* Control Manager */
/*		17,$0300,	/* System Loader */
		18,$0301,	/* QD Aux */
		19,$0300,	/* print manager */
		20,$0301,	/* LineEdit tool set */
		21,$0302,	/* Dialog Manager */
		22,$0300,	/* Scrap manager */
		23,$0301,	/* standard file */
/*		25,$0104,	/* NoteSynth */
/*		26,$0104,	/* Note Seq */
		27,$0301,	/* Font manager */
		28,$0301,	/* list manager */
/*		29,$0101,	/* ACE */
/*		32,$0103,	/* Midi Tools */
		34,$0101	/* text edit */
	}
};

/********/

/*---------------------------------------------------------------------------*/
/*
/* Tabs Window
/*
/*---------------------------------------------------------------------------*/

resource rWindParam1 (TabsWindow) {
	fVis+fTitle+fMove,										/* Frame Bits -- title is a drag */
	TabsWindow,												/* title ID   			*/
	0,														/* ref Con    			*/
	{0,0,0,0},												/* Zoom Rect  			*/
	0,														/* color table id 		*/
	{0,0},													/* origin 				*/
	{0,0},													/* data size 			*/
	{0,0},													/* max height-width		*/
	{0,0},													/* scroll amount, hor,ver */
	{0,0},													/* page amount */
	0,														/* wInfo Ref Con */
	0,														/* wInfo height */
	{62,320-190,152,320+190},								/* window Position */
	infront,												/* wPlane */
	TabsWindow,												/* Control Ref */
	refIsResource*0x0100+resourceToResource  				/* descriptor */
};
resource rPString (TabsWindow) {"Change Tabs"};

/********/

resource rControlList (TabsWindow) {
	{
		TabsWindow+TabsOK,
		TabsWindow+TabsCancel,
		TabsWindow+MerlinTabs,
		TabsWindow+TabChr,
		TabsWindow+TabsData,
		TabsWindow+TabsDataText,
		TabsWindow+TabChrText,
		TabsWindow+MerlinTabsData	/* The MerlinTabsData control is so that the  */
	}								/* data is in a resource.  If somebody wants  */
};									/* to change the tab stops with a resource    */
									/* editor, this allows them.				  */
/********/

resource rControlTemplate (TabsWindow+TabsOK) {
	TabsOK,
	{62, 116, 0, 0},
	SimpleButtonControl{{
		DefaultButton,
		fCtlWantsEvents+fctlProcNotPtr+RefIsResource,
		0,						/* ref con */
		TabsWindow+TabsOK,		/* title ref */
		0,						/* color table not used */
		{"\015","\015",0,0}		/* key equiv */
	}};
};
resource rpString (TabsWindow+TabsOK) {"OK"};

/********/

resource rControlTemplate (TabsWindow+TabsCancel) {
	TabsCancel,
	{62, 20, 0, 0},
	SimpleButtonControl{{
		NormalButton,
		fCtlWantsEvents+fctlProcNotPtr+RefIsResource,
		0,								/* ref con */
		TabsWindow+TabsCancel,			/* title ref */
		0,								/* color table not used */
		{".",".",$0100,$1B00}			/* key equiv */
	}};
};
resource rpString (TabsWindow+TabsCancel) {"Cancel"};

/********/

resource rControlTemplate (TabsWindow+MerlinTabs) {
	MerlinTabs,
	{36, 216, 0, 0},
	SimpleButtonControl{{
		NormalButton,
		fctlProcNotPtr+RefIsResource,
		0,						/* ref con */
		TabsWindow+MerlinTabs,	/* title ref */
		0						/* color table not used */
	}};
};
resource rpString (TabsWindow+MerlinTabs) {"Merlin tab stops"};

/********/

resource rControlTemplate (TabsWindow+TabsData) {
	TabsData,
	{19, 16, 32, 190 * 2 - 16},
	EditLineControl{{
		0,
		fctlCanBeTarget+fctlWantsEvents+fctlProcNotPtr+RefIsResource,
		0,
		40,								/* Max Length */
		TabsWindow+TabsData
	}};
}; 
resource rPString (TabsWindow+TabsData) {"4\311"};

/********/

resource rControlTemplate (TabsWindow+TabChr) {
	TabChr,
	{36, 130, 49, 166},
	EditLineControl{{
		0,
		fctlCanBeTarget+fctlWantsEvents+fctlProcNotPtr+RefIsResource,
		0,
		3,								/* Max Length */
		TabsWindow+TabChr
	}};
}; 
resource rPString (TabsWindow+TabChr) {"9"};

/********/

resource rControlTemplate (TabsWindow+TabsDataText) {
	TabsDataText,
	{7,16,16,340},
	StatTextControl{{
		ctlInactive,						/* flag */
		fctlProcNotPtr+RefIsResource,		/* more flags */
		0,
		TabsWindow+TabsDataText
	}};
}; 
resource rTextForLETextBox2 (TabsWindow+TabsDataText) {"Enter tab stop data:"};

/********/

resource rControlTemplate (TabsWindow+TabChrText) {
	TabChrText,
	{38, 16, 47, 128},
	StatTextControl{{
		ctlInactive,						/* flag */
		fctlProcNotPtr+RefIsResource,		/* more flags */
		0,
		TabsWindow+TabChrText
	}};
}; 
resource rTextForLETextBox2 (TabsWindow+TabChrText) {"Tab character:"};

/********/

resource rControlTemplate (TabsWindow+MerlinTabsData) {
	MerlinTabsData,
	{1000,1000,1020,1020},	/* We don't ever want to see this data -- reference only. */
	EditLineControl{{
		ctlInactive+ctlInvis,
		fctlCanBeTarget+fctlWantsEvents+fctlProcNotPtr+RefIsResource,
		0,
		40,								/* Max Length */
		TabsWindow+MerlinTabsData
	}};
};
resource rPString (TabsWindow+MerlinTabsData) {"9,15,26"};

/*---------------------------------------------------------------------------*/
/*
/* Printing Window
/*
/*---------------------------------------------------------------------------*/

resource rWindParam1 (PrintingWindow) {
	fVis+fAlert,											/* Frame Bits			*/
	0,														/* title ID   			*/
	0,														/* ref Con    			*/
	{0,0,0,0},												/* Zoom Rect  			*/
	0,														/* color table id 		*/
	{0,0},													/* origin 				*/
	{0,0},													/* data size 			*/
	{0,0},													/* max height-width		*/
	{0,0},													/* scroll amount, hor,ver */
	{0,0},													/* page amount */
	0,														/* wInfo Ref Con */
	0,														/* wInfo height */
	{90,320-230,124,320+230},								/* window Position */
	infront,												/* wPlane */
	PrintingWindow,											/* Control Ref */
	refIsResource*0x0100+resourceToResource  				/* descriptor */
};

/********/

resource rControlList (PrintingWindow) {
	{
		PrintingWindow+PrintingText,
		PrintingWindow+PrintingCmdDotText
	}
};

/********/

resource rControlTemplate (PrintingWindow+PrintingText) {
	PrintingText,
	{5,0,14,460},
	StatTextControl{{
		ctlInactive,						/* flag */
		fctlProcNotPtr+RefIsResource,		/* more flags */
		0,
		PrintingWindow+PrintingText
	}};
}; 
resource rTextForLETextBox2 (PrintingWindow+PrintingText) {
	"\$01J\$01\$00Now printing your document."
};

/********/

resource rControlTemplate (PrintingWindow+PrintingCmdDotText) {
	PrintingCmdDotText,
	{16,0,25,460},
	StatTextControl{{
		ctlInactive,						/* flag */
		fctlProcNotPtr+RefIsResource,		/* more flags */
		0,
		PrintingWindow+PrintingCmdDotText
	}};
}; 
resource rTextForLETextBox2 (PrintingWindow+PrintingCmdDotText) {
	"\$01J\$01\$00To cancel printing, hold down the \021 key and press period (.)."
};































/*---------------------------------------------------------------------------*/
/*
/* About Window
/*
/* This is the template for the about window, with controls.
/*
/*---------------------------------------------------------------------------*/

resource rWindParam1 (AboutWindow) {
	fVis+fAlert,											/* Frame Bits			*/
	0,														/* title ID   			*/
	0,														/* ref Con    			*/
	{0,0,0,0},												/* Zoom Rect  			*/
	0,														/* color table id 		*/
	{0,0},													/* origin 				*/
	{0,0},													/* data size 			*/
	{0,0},													/* max height-width		*/
	{0,0},													/* scroll amount, hor,ver */
	{0,0},													/* page amount */
	0,														/* wInfo Ref Con */
	0,														/* wInfo height */
	{$15,$A0,$BA,$1E0},										/* window Position */
	infront,												/* wPlane */
	AboutWindow,											/* Control Ref */
	refIsResource*0x0100+resourceToResource  				/* descriptor */
};

/********/

resource rControlList (AboutWindow) {
	{
		AboutWindow+AboutText,
		AboutWindow+AboutOK
	}
};

/********/

resource rControlTemplate (AboutWindow+AboutText) {
	AboutText,
	{$10,$20,$81,$120},
	StatTextControl{{
		ctlInactive,						/* flag */
		fctlProcNotPtr+RefIsResource,		/* more flags */
		0,
		AboutWindow+AboutText
	}};
}; 

/********/

resource rTextForLETextBox2 (AboutWindow+AboutText) {
	TBCenterJust
	TBStyleOutline
	"LISTER"
	TBEndOfLine
	TBStylePlain
	"A program to list programs in various pretty formats."
	TBEndOfLine
	TBEndOfLine
	"by"
	TBEndOfLine
	"Keith Rollin"
	TBEndOfLine
	TBEndOfLine
	"Copyright Apple Computer, Inc."
	TBEndOfLine
	"All Rights Reserved"
	TBEndOfLine
	"Version 3.0"
	TBEndOfLine
	TBEndOfLine
	"NOTE:  Try the menus now!"
};

/********/

resource rControlTemplate (AboutWindow+AboutOK) {
	AboutOK,
	{$88,$90,0,0},
	SimpleButtonControl{{
		DefaultButton,
		fCtlWantsEvents+fctlProcNotPtr+RefIsResource,
		0,						/* ref con */
		AboutWindow+AboutOK,	/* title ref */
		0,						/* color table not used */
		{"\015","\015",0,0}		/* key equiv */
	}};
};
resource rpString (AboutWindow+AboutOK) {"OK"};


/*---------------------------------------------------------------------------*/
/*
/* Main Window
/*
/* This is the template for the main window, with controls.
/*
/*---------------------------------------------------------------------------*/

resource rWindParam1 (MainWindow) {
	fTitle+fMove,											/* Frame Bits -- title is a drag */
	MainWindow,												/* title ID   			*/
	0,														/* ref Con    			*/
	{0,0,0,0},												/* Zoom Rect  			*/
	0,														/* color table id 		*/
	{0,0},													/* origin 				*/
	{0,0},													/* data size 			*/
	{0,0},													/* max height-width		*/
	{0,0},													/* scroll amount, hor,ver */
	{0,0},													/* page amount */
	0,														/* wInfo Ref Con */
	0,														/* wInfo height */
	{30,20,194,620},										/* window Position */
	infront,												/* wPlane */
	MainWindow,												/* Control Ref */
	refIsResource*0x0100+resourceToResource  				/* descriptor */
};
resource rPString (MainWindow) {"LISTER"};

/********/

resource rControlList (MainWindow) {
	{
		MainWindow+ChFont,
		MainWindow+BoxProc,
		MainWindow+ChangeTabs,
		MainWindow+Footer,
		MainWindow+Header,
		MainWindow+Columns,
		MainWindow+ColumnText,
		MainWindow+HeaderText,
		MainWindow+FooterText,
		MainWindow+UseBorder,
		MainWindow+Hint,
		MainWindow+TextAsIs,
		MainWindow+HiBitOff,
		MainWindow+HiBitOn,
		TabsWindow+TabsData,
		TabsWindow+TabChr
	}
};

/********/

resource rControlTemplate (MainWindow+TextAsIs) {
	TextAsIs,									/* control ID */
	{115,22,0,0},								/* control rect */
	RadioControl{{								/* control type */
		1,										/* flag */
		fctlProcNotPtr+RefIsResource,			/* more flags */
		0,										/* ref con */
		MainWindow+TextAsIs,					/* title ref */
		1,										/* initial value */
		0										/* color table not used */
	}};
}; 
resource rpString (MainWindow+TextAsIs) {"Use character ""as is"""};

/********/

resource rControlTemplate (MainWindow+HiBitOff) {
	HiBitOff,									/* control ID */
	{127,22,0,0},								/* control rect */
	RadioControl{{								/* control type */
		1,										/* flag */
		fctlProcNotPtr+RefIsResource,			/* more flags */
		0,										/* ref con */
		MainWindow+HiBitOff,					/* title ref */
		0,										/* initial value */
		0										/* color table not used */
	}};
}; 
resource rpString (MainWindow+HiBitOff) {"Force hi-bit off characters"};

/********/

resource rControlTemplate (MainWindow+HiBitOn) {
	HiBitOn,									/* control ID */
	{139,22,0,0},								/* control rect */
	RadioControl{{								/* control type */
		1,										/* flag */
		fctlProcNotPtr+RefIsResource,			/* more flags */
		0,										/* ref con */
		MainWindow+HiBitOn,						/* title ref */
		0,										/* initial value */
		0										/* color table not used */
	}};
}; 
resource rpString (MainWindow+HiBitOn) {"Force hi-bit on characters"};

/********/

resource rControlTemplate (MainWindow+ChFont) {
	ChFont,
	{89,200-50,103,200+50},
	SimpleButtonControl{{
		NormalButton,
		fctlProcNotPtr+RefIsResource,
		0,					/* ref con */
		MainWindow+ChFont,	/* title ref */
		0					/* color table not used */
	}};
};
resource rpString (MainWindow+ChFont) {"Choose Font"};

/********/

resource rControlTemplate (MainWindow+ChangeTabs) {
	ChangeTabs,
	{89,330-50,103,330+50},
	SimpleButtonControl{{
		NormalButton,
		fctlProcNotPtr+RefIsResource,
		0,						/* ref con */
		MainWindow+ChangeTabs,	/* title ref */
		0						/* color table not used */
	}};
};
resource rpString (MainWindow+ChangeTabs) {"Change Tabs"};

/********/

resource rControlTemplate (MainWindow+Header) {
	Header,
	{35,12,50,588},
	EditLineControl{{
		0,
		fctlCanBeTarget+fctlWantsEvents+fctlProcNotPtr+RefIsResource,
		0,
		128,								/* Max Length */
		MainWindow+Header
	}};
}; 
resource rPString (MainWindow+Header) {"@d @t|@l|Page: @p"};

/********/

resource rControlTemplate (MainWindow+Footer) {
	Footer,
	{65,12,80,588},
	EditLineControl{{
		0,
		fctlCanBeTarget+fctlWantsEvents+fctlProcNotPtr+RefIsResource,
		0,
		128,								/* Max Length */
		MainWindow+Footer
	}};
}; 
resource rPString (MainWindow+Footer) {""};

/********/

resource rControlTemplate (MainWindow+UseBorder) {
	UseBorder,
	{91,445,0,0},
	CheckControl{{
		0,
		fctlProcNotPtr+RefIsResource,
		0,
		MainWindow+UseBorder,
		1,
		0
	}};
}; 
resource rpString (MainWindow+UseBorder) {"Use borders"};

/********/

resource rControlTemplate (MainWindow+Columns) {
	Columns,
	{88,22,103,42},
	EditLineControl{{
		0,
		fctlCanBeTarget+fctlWantsEvents+fctlProcNotPtr+RefIsResource,
		0,
		1,									/* Max Length */
		MainWindow+Columns
	}};
}; 
resource rPString (MainWindow+Columns) {"2"};

/********/

resource rControlTemplate (MainWindow+ColumnText) {
	ColumnText,
	{91,50,100,150},
	StatTextControl{{
		ctlInactive,						/* flag */
		fctlProcNotPtr+RefIsResource,		/* more flags */
		0,
		MainWindow+ColumnText
	}};
}; 
resource rTextForLETextBox2 (MainWindow+ColumnText) {"Column(s)"};

/********/

resource rControlTemplate (MainWindow+HeaderText) {
	HeaderText,
	{25,12,34,588},
	StatTextControl{{
		ctlInactive,						/* flag */
		fctlProcNotPtr+RefIsResource,		/* more flags */
		0,
		MainWindow+HeaderText
	}};
}; 
resource rTextForLETextBox2 (MainWindow+HeaderText) {
	"Header:    {@D=Date, @T=Time, @L/@S=Lg/Sh File name, @P=Pg#, |=Field Divider}"
};

/********/

resource rControlTemplate (MainWindow+FooterText) {
	FooterText,
	{55,12,64,588},
	StatTextControl{{
		ctlInactive,						/* flag */
		fctlProcNotPtr+RefIsResource,		/* more flags */
		0,
		MainWindow+FooterText
	}};
}; 
resource rTextForLETextBox2 (MainWindow+FooterText) {"Footer:"};

/********/

resource rControlTemplate (MainWindow+Hint) {
	Hint,
	{6,20,16,580},
	StatTextControl{{
		ctlInactive,						/* flag */
		fctlProcNotPtr+RefIsResource,		/* more flags */
		0,
		MainWindow+Hint
	}};
}; 
resource rTextForLETextBox2 (MainWindow+Hint) {
	"\$01J\$01\$00This is a Movable/Modal dialog, so you can use the menus."
};

/*********************************************************************/
/*
/* 			Menus
/*
/*********************************************************************/

#define AppleMenuID		$901
#define FileMenuID		$902
#define EditMenuID		$903

#define UndoID 			250
#define CutID			251
#define CopyID 			252
#define PasteID 		253
#define ClearID 		254
#define CloseID			255

#define AboutID			301

#define OpenFileID		401
#define ChoosePrinterID	402
#define PageSetupID		403
#define PrintID			404
#define QuitID			499

/********/

resource rMenuBar (1) {
	{
		AppleMenuID,FileMenuID,EditMenuID
	};
};

/********/

resource rMenu (AppleMenuID) {
	AppleMenuID,0xA008,AppleMenuID,{
		AboutID
	};
};
resource rPString (AppleMenuID) {"@"};

/********/

resource rMenu (FileMenuID)	{
	FileMenuID,0xA008,FileMenuID,{
		OpenFileID,CloseID,ChoosePrinterID,PageSetupID,PrintID,QuitID
	};
};
resource rPString (FileMenuID) {" File "};

/********/

resource rMenu (EditMenuID)	{
	EditMenuID,0xA008,EditMenuID,{
		UndoID,CutID,CopyID,PasteID,ClearID
	};
};
resource rPString (EditMenuID) {" Edit "};

/********/

resource rMenuItem (AboutID) {AboutID,"","",0,0x8040,AboutID};
resource rPString (AboutID) {"About LISTER..."};

/********/

resource rMenuItem (OpenFileID) {OpenFileID,"O","o",0,0x8000,OpenFileID};
resource rPString (OpenFileID) {"Choose File..."};

resource rMenuItem (CloseID) {CloseID,"W","w",0,0x8040,CloseID};
resource rPString (CloseID) {"Close"};

resource rMenuItem (ChoosePrinterID) {ChoosePrinterID,"","",0,0x8000,ChoosePrinterID};
resource rPString (ChoosePrinterID) {"Choose Printer..."};

resource rMenuItem (PageSetupID) {PageSetupID,"","",0,0x8000,PageSetupID};
resource rPString (PageSetupID) {"Page Setup..."};

resource rMenuItem (PrintID) {PrintID,"P","p",0,0x80C0,PrintID};
resource rPString (PrintID) {"Print..."};

resource rMenuItem (QuitID) {QuitID,"Q","q",0,0x8000,QuitID};
resource rPString (QuitID) {"Quit"};

/********/

resource rMenuItem (UndoID) {UndoID,"","",0,0x8040,UndoID};
resource rPString (UndoID) {"Undo"};

resource rMenuItem (CutID) {CutID,"X","x",0,0x8000,CutID};
resource rPString (CutID) {"Cut"};

resource rMenuItem (CopyID)	{CopyID,"C","c",0,0x8000,CopyID};
resource rPString (CopyID) {"Copy"};

resource rMenuItem (PasteID) {PasteID,"V","v",0,0x8000,PasteID};
resource rPString (PasteID) {"Paste"};

resource rMenuItem (ClearID) {ClearID,"","",0,0x8000,ClearID};
resource rPString (ClearID) {"Clear"};

/*************************************************************************/


#define rMyControlTemplate 0x8004  
type rMyControlTemplate {
	integer = 6+$$optionalcount (Fields);						
	longint;												/* Application defined ID */
	rect;													/* controls bounding rectangle */
	longint;
	integer;
	integer;
	longint;
	optional Fields {
		integer;	/* starting value */
		longint;	/* color table */
	};
};	

resource rMyControlTemplate (MainWindow+BoxProc) {
	/* 6, */
	BoxProc, 
	{115, 445, 0, 0},
	BoxProc,
	0,
	FctlProcNotPtr+0x8,		/* the +0x8 indicates that the color table is a resource */
	0,
	{
		0x7F-0x04,		/* initial value   */
		BoxProc			/* color table now */
	};
};

data 0x800D (BoxProc) {$"0000 9999 7777"};
	/* BoxProc color table 					*/
	/* word; pattern for hilited part		*/
	/* word; pattern for dimmed part		*/
	/* word; pattern for tracking rectangle */

/* The following puts our proc in the resource fork */
/* The 'fixed flag tells the memory manager not to move the proc around
   once it's been loaded.  The 'convert' flag tells the resource manager to use
   the converter for this type of resource.  In this case the converter calls
   the system loader to load and relocate this code segment */

read 0x800C (BoxProc, fixed, convert)  ":o:custproc.load";

